% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addDemographics.R
\name{addPriorObservation}
\alias{addPriorObservation}
\title{Compute the number of days of prior observation in the current observation period
at a certain date}
\usage{
addPriorObservation(
  x,
  indexDate = "cohort_start_date",
  priorObservationName = "prior_observation",
  priorObservationType = "days",
  name = NULL
)
}
\arguments{
\item{x}{Table with individuals in the cdm.}

\item{indexDate}{Variable in x that contains the date to compute the
demographics characteristics.}

\item{priorObservationName}{Prior observation variable name.}

\item{priorObservationType}{Whether to return a "date" or the number of
"days".}

\item{name}{Name of the new table, if NULL a temporary table is returned.}
}
\value{
cohort table with added column containing prior observation of the
individuals.
}
\description{
Compute the number of days of prior observation in the current observation period
at a certain date
}
\examples{
\donttest{
library(PatientProfiles)

cdm <- mockPatientProfiles(source = "duckdb")

cdm$cohort1 |>
  addPriorObservation()

}
}
