% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_data_processing.R
\name{data_norm}
\alias{data_norm}
\title{Normalization of grammage units and recalculation of prices and quantities with respect to these units}
\usage{
data_norm(
  data = data.frame(),
  rules = list(c("ml", "l", 1000), c("g", "kg", 1000)),
  all = TRUE
)
}
\arguments{
\item{data}{The user's data frame. The data frame must contain the following columns: \code{prices} (as positive numeric), \code{quantities} (as positive numeric), \code{grammage} (as numeric or character) and \code{unit} (as character).}

\item{rules}{User rules for transforming \code{grammage}, \code{unit}, \code{prices} and \code{quantities} of products. For instance, a rule \code{("ml","l",1000)} changes the 'old' grammage unit: \code{ml} into the new one: \code{l} on the basis of the provided relation: \code{1000ml=1l}. As a consequence, for each product which is sold in liters \code{l} , the unit price and quantity are calculated.}

\item{all}{A logical value indicating whether the resulting data frame is to be limited to products with detected  grammage. Its default value is \code{TRUE} which means that not transformed rows (products) are also returned.}
}
\value{
The function returns the user's data frame with two transformed columns: \code{grammage} and \code{unit}, and two rescaled columns: \code{prices} and \code{quantities}. The above-mentioned transformation and rescaling take into consideration the user \code{rules}. Recalculated prices and quantities concern grammage units defined as the second parameter in the given rule.
}
\description{
The function normalizes grammage units of products and recalculates product prices and quantities with respect to these normalized grammage units.
}
\examples{
# Preparing a data set
\donttest{data<-data_unit(dataU, units=c("g|ml|kg|l"), multiplication="x")}
# Normalization of grammage units
\donttest{data_norm(data, rules=list(c("ml","l",1000), c("g","kg",1000)))}
}
