% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.profileLadder.R
\name{print.profileLadder}
\alias{print.profileLadder}
\title{Print Objects of the S3 Class \code{profileLadder}}
\usage{
\method{print}{profileLadder}(x, fancy.print = getOption("profileLadder.fancy", TRUE), ...)
}
\arguments{
\item{x}{an object of the class \code{profileLadder} resulting from a call
of one of the functions \code{parallelReserve()}, \code{mcReserve}, or
\code{as.profileLadder()}}

\item{fancy.print}{logical to indicate whether fancy run-off triangle should be
printed or a standard output should be used instead. The default choice is \code{TRUE}.
Note that that fancy print option uses by DEFAULT zero decimal digits.
Specific colors for the fancy print option and the number of decimal points
to be used can be set by the function \code{set.fancy.print()}.
The fancy print option can be supressed by \code{options(profileLadder.fancy = FALSE)}.}

\item{...}{further arguments passed to \code{print()}}
}
\value{
displays information resulting from a call of the \code{parallelReserve()}
function or the \code{mcReserve} function
}
\description{
Function to organize and print the outputs provided by the function
\code{parallelReserve()} and the function \code{mcReserve}
}
\examples{
data(CameronMutual)
## full run-off triangle printed with the fancy mode
x <- as.profileLadder(CameronMutual)
print(x) 

## run-off triangle with unobserved future payments 
x <- as.profileLadder(observed(CameronMutual))
print(x) 

## the same run-off triangle using a standard printing method 
options(profileLadder.fancy = FALSE)
print(x)

}
\seealso{
\code{\link[=as.profileLadder]{as.profileLadder()}}, \code{\link[=set.fancy.print]{set.fancy.print()}}, \code{\link[=parallelReserve]{parallelReserve()}}, \code{\link[=mcReserve]{mcReserve()}}
}
