% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MTL.R
\name{cvMTL}
\alias{cvMTL}
\title{K-fold cross-validation}
\usage{
cvMTL(
  X,
  Y,
  type = "Classification",
  Regularization = "L21",
  Lam1_seq = 10^seq(1, -4, -1),
  Lam2 = 0,
  G = NULL,
  k = 2,
  opts = list(init = 0, tol = 10^-3, maxIter = 1000),
  stratify = FALSE,
  nfolds = 5,
  ncores = 2,
  parallel = FALSE
)
}
\arguments{
\item{X}{A set of feature matrices}

\item{Y}{A set of responses, could be binary (classification
problem) or continues (regression problem). The valid
value of binary outcome \eqn{\in\{1, -1\}}}

\item{type}{The type of problem, must be \code{Regression} or
\code{Classification}}

\item{Regularization}{The type of MTL algorithm (cross-task regularizer). The value must be
one of \{\code{L21}, \code{Lasso}, \code{Trace}, \code{Graph}, \code{CMTL} \}}

\item{Lam1_seq}{A positive sequence of \code{Lam1} which controls the
cross-task regularization}

\item{Lam2}{A positive constant \eqn{\lambda_{2}} to improve the
generalization performance}

\item{G}{A matrix to encode the network information. This parameter
is only used in the MTL with graph structure (\code{Regularization=Graph} )}

\item{k}{A positive number to modulate the structure of clusters
with the default of 2. This parameter is only used in MTL with
clustering structure (\code{Regularization=CMTL} ) Note, the larger number is adapted to more
complex clustering structure.}

\item{opts}{Options of the optimization procedure. One can set the
initial search point, the tolerance and the maximized number of
iterations through the parameter. The default value is
\code{list(init=0,  tol=10^-3, maxIter=1000)}}

\item{stratify}{\code{stratify=TRUE} is used for stratified
cross-validation}

\item{nfolds}{The number of folds}

\item{ncores}{The number of cores used for parallel computing with the default value of 2}

\item{parallel}{\code{parallel=TRUE} is used for parallel computing}
}
\value{
The estimated \eqn{\lambda_1} and related information
}
\description{
Perform the k-fold cross-validation to estimate the \eqn{\lambda_1}.
}
\examples{
#create the example data
data<-Create_simulated_data(Regularization="L21", type="Classification")
#perform the cross validation
cvfit<-cvMTL(data$X, data$Y, type="Classification", Regularization="L21", 
    Lam2=0, opts=list(init=0,  tol=10^-6, maxIter=1500), nfolds=5,
    stratify=TRUE, Lam1_seq=10^seq(1,-4, -1))
#show meta-infomration
str(cvfit)
#plot the CV accuracies across lam1 sequence
plot(cvfit)
}
