% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect.R
\name{detect_regimes}
\alias{detect_regimes}
\title{Detect Regime Changes in Time Series}
\usage{
detect_regimes(
  data,
  method = c("pelt", "bocpd", "cusum", "binseg", "wbs", "shiryaev", "ensemble"),
  type = c("both", "mean", "variance", "trend", "distribution"),
  mode = c("offline", "online"),
  n_changepoints = "multiple",
  penalty = "BIC",
  min_segment = 2,
  prior = NULL,
  hazard = NULL,
  threshold = NULL,
  uncertainty = TRUE,
  bootstrap_reps = 200,
  ...
)
}
\arguments{
\item{data}{Numeric vector, time series (ts object), or matrix for multivariate data.
For matrices, rows are observations and columns are variables.}

\item{method}{Detection method. One of:
\itemize{
\item \code{"pelt"}: Pruned Exact Linear Time (default for offline)
\item \code{"bocpd"}: Bayesian Online Changepoint Detection
\item \code{"cusum"}: Cumulative Sum
\item \code{"binseg"}: Binary Segmentation
\item \code{"wbs"}: Wild Binary Segmentation
\item \code{"shiryaev"}: Shiryaev-Roberts procedure
\item \code{"ensemble"}: Combination of multiple methods
}}

\item{type}{Type of change to detect:
\itemize{
\item \code{"mean"}: Changes in mean only
\item \code{"variance"}: Changes in variance only
\item \code{"both"}: Changes in mean and/or variance (default)
\item \code{"trend"}: Changes in linear trend
\item \code{"distribution"}: Non-parametric distributional changes
}}

\item{mode}{Operation mode:
\itemize{
\item \code{"offline"}: Retrospective analysis with full data (default)
\item \code{"online"}: Sequential analysis for monitoring
}}

\item{n_changepoints}{Expected number of changepoints:
\itemize{
\item \code{"single"}: Detect at most one changepoint
\item \code{"multiple"}: Detect multiple changepoints (default)
\item An integer: Detect exactly this many changepoints
}}

\item{penalty}{Penalty for model complexity (offline methods):
\itemize{
\item \code{"BIC"}: Bayesian Information Criterion (default)
\item \code{"AIC"}: Akaike Information Criterion
\item \code{"MBIC"}: Modified BIC
\item \code{"MDL"}: Minimum Description Length
\item A number: Manual penalty value
}}

\item{min_segment}{Minimum segment length (number of observations)}

\item{prior}{Prior specification for Bayesian methods (from prior functions)}

\item{hazard}{Hazard prior for changepoint occurrence (Bayesian methods)}

\item{threshold}{Detection threshold (for online/CUSUM methods)}

\item{uncertainty}{Logical; if TRUE, compute confidence intervals}

\item{bootstrap_reps}{Number of bootstrap replicates for uncertainty (if uncertainty = TRUE)}

\item{...}{Additional arguments passed to specific methods}
}
\value{
An object of class \code{"regime_result"} containing:
\itemize{
\item \code{changepoints}: Vector of detected changepoint locations
\item \code{n_changepoints}: Number of changepoints detected
\item \code{segments}: List of segment information (start, end, parameters)
\item \code{confidence_intervals}: Confidence intervals for changepoint locations
\item \code{existence_probability}: Probability that each changepoint exists
\item \code{posterior}: Posterior distribution (Bayesian methods)
\item \code{information_criterion}: BIC/AIC values
\item \code{method}: Method used
\item \code{call}: The function call
}
}
\description{
Main function for detecting regime changes (changepoints) in time series data.
Supports multiple detection methods, both frequentist and Bayesian, and can
operate in offline (retrospective) or online (sequential) modes.
}
\examples{

set.seed(123)
data <- c(rnorm(100, mean = 0), rnorm(100, mean = 3))


result <- detect_regimes(data)
print(result)
plot(result)


result <- detect_regimes(data, method = "bocpd",
                         prior = normal_gamma())


result <- detect_regimes(data, method = "cusum",
                         mode = "online", threshold = 5)

}
