% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot.regime_result}
\alias{plot.regime_result}
\title{Plot Regime Change Detection Results}
\usage{
\method{plot}{regime_result}(
  x,
  type = c("data", "segments", "posterior", "diagnostic", "runlength"),
  show_ci = TRUE,
  show_segments = TRUE,
  title = NULL,
  ...
)
}
\arguments{
\item{x}{A regime_result object}

\item{type}{Type of plot:
\itemize{
\item \code{"data"}: Data with changepoints marked (default)
\item \code{"segments"}: Data colored by segment
\item \code{"posterior"}: Posterior probability of change (Bayesian methods)
\item \code{"diagnostic"}: Diagnostic statistics
\item \code{"runlength"}: Run length distribution (BOCPD)
}}

\item{show_ci}{Show confidence intervals if available}

\item{show_segments}{Color segments differently}

\item{title}{Plot title}

\item{...}{Additional arguments passed to ggplot}
}
\value{
A ggplot2 object
}
\description{
Create visualizations of changepoint detection results.
}
\examples{
data <- c(rnorm(100), rnorm(100, mean = 2))
result <- detect_regimes(data)
plot(result)
plot(result, type = "segments")

}
