% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ireland.R
\name{ireland}
\alias{ireland}
\title{ireland}
\usage{
ireland(site, variable, start_date = NULL, end_date = NULL, sites = FALSE, ...)
}
\arguments{
\item{site}{Ireland gauge number}

\item{variable}{Character. Either \code{stage} or \code{discharge}.}

\item{start_date}{Character. Optional start date with format
YYYY-MM-DD. Default is 1900-01-01.}

\item{end_date}{Character. End date with format YYYY-MM-DD.
Default is the current date.}

\item{sites}{Logical. If TRUE, returns a list of measurement
sites.}

\item{...}{Additional arguments. None implemented.}
}
\value{
data frame of discharge time-series
}
\description{
Retrieve Ireland gauge data
}
\examples{
\dontrun{
start_date <- as.Date("1968-01-01")
end_date <- as.Date("1970-12-31")
df <- ireland('25014',"discharge", start_date, end_date)
plot(df$Date, df$Q)
}
}
