##
#  Copyright (c) 2010-2018 LabKey Corporation
# 
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
# 
#      http://www.apache.org/licenses/LICENSE-2.0
# 
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
##

## R Script generated by LabKey Server on 7 Jan 2010 17:10:00
#
# This script makes use of the LabKey Remote API for R package (Rlabkey), which can be obtained via CRAN
# using the package name "Rlabkey".  The Rlabkey package also depends on the "jsonlite" and "httr" packages.
#
# See https://www.labkey.org/Documentation/wiki-page.view?name=rAPI for more information.


labkey.getSchemas <- function(baseUrl=NULL, folderPath)
{
    baseUrl=labkey.getBaseUrl(baseUrl)

    ## Validate required parameters
    if (missing(folderPath)) stop (paste("A value must be specified for folderPath."))

    ## Construct url
    params <- list("apiVersion"="9.3")
    myurl <- labkey.buildURL(baseUrl, "query", "getSchemas.api", folderPath, params)

    ## Execute via our standard GET function
    mydata <- labkey.get(myurl)

    decode <- fromJSON(mydata, simplifyVector=FALSE, simplifyDataFrame=FALSE)
    cn<-names(decode)
    newdata<- as.data.frame(cn)
    names(newdata)[1]<-"schemaName"

    return(newdata)
}


