% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{occ_bien}
\alias{occ_bien}
\title{Occurrence records of Yellow Trumpet Tree from BIEN}
\format{
A data frame containing spatial coordinates, taxonomic information, and
metadata returned by BIEN, after cleaning.
Columns include (but may not be limited to):
\itemize{
\item \code{scrubbed_species_binomial}: Cleaned species name
\item \code{longitude}, \code{latitude}: Geographic coordinates
\item \code{country}, \code{state_province}, and other political boundary fields
}
}
\usage{
occ_bien
}
\description{
A cleaned dataset of occurrence records for Yellow Trumpet Tree
(\emph{Handroanthus serratifolius}) retrieved from the BIEN database.
The raw data were downloaded using \code{get_bien()}

The dataset was subsequently processed with the package’s internal
flagging workflow (\code{flag_duplicates()} and \code{remove_flagged()}) to remove
duplicated records.
}
\examples{
# View dataset
head(occ_bien)

# Number of records
nrow(occ_bien)


}
\seealso{
\code{get_bien()}
}
\keyword{datasets}
