% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RvegMerge.r
\name{RvegMerge}
\alias{RvegMerge}
\title{RvegMerge: Merge Two Rveg Databases}
\usage{
RvegMerge(database_1, database_2, export = "export")
}
\arguments{
\item{database_1}{Character. The path and name of the first \code{Rveg} database (e.g., \code{"path/to/db1"}).}

\item{database_2}{Character. The path and name of the second \code{Rveg} database (e.g., \code{"path/to/db2"}).}

\item{export}{Character. The output path and name where the merged database files
(\verb{*HEAD.csv} and \verb{*REL.csv}) will be saved. Defaults to a temporary directory.}
}
\value{
Writes two linked CSV files to the location specified by \code{export}, representing
the combined Rveg database.
}
\description{
Combines two separate \code{Rveg} databases into a single, unified database.
This function cleanly merges both the species composition data (REL) and the
environmental plot header data (HEAD), and seamlessly combines their metadata.
}
\details{
During the merge process:
\itemize{
\item \strong{Relevé Re-indexing:} The relevé columns from both databases are sequentially re-indexed (e.g., \code{X1}, \code{X2}, ..., \code{Xn}) to prevent column name collisions.
\item \strong{Checklist Validation:} The function checks the metadata of both databases to ensure they were built using the same species checklist. If the checklists differ, it will issue a warning, though the merge will still proceed.
\item \strong{Missing Species:} If a species exists in one database but not the other, the function automatically fills the absences with \code{0}.
\item \strong{Metadata:} The total number of relevés is updated, and any custom species (\code{extra_spec}) from both databases are concatenated together.
}
}
\examples{
# Example: Merging the built-in database with itself
db_path <- file.path(path.package("Rveg"), "extdata/ExampleDB", "example_1")

RvegMerge(
  database_1 = db_path,
  database_2 = db_path
)
}
\seealso{
\code{\link{RvegCombine}} for manipulating data within a single database, \code{\link{addReleve}} for adding individual relevés.
}
