% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_prediction.R
\name{simulation_prediction_binary}
\alias{simulation_prediction_binary}
\title{Simulate Binary Longitudinal Data for Prediction}
\usage{
simulation_prediction_binary(
  train_prop = 0.7,
  n_subject = 1000,
  n_obs_per_sub = 5,
  seed = NULL,
  nonlinear = FALSE,
  residual = c("normal", "logistic", "t3", "t2"),
  randeff = c("MVN", "MVN_mixture", "skewed_MVN", "MVT3", "MVT2")
)
}
\arguments{
\item{train_prop}{A numeric value between 0 and 1 indicating the proportion of the population to be used
for the training set. Default: \code{0.7}.}

\item{n_subject}{An integer specifying the total number of subjects in the population. Default: \code{1000}.}

\item{n_obs_per_sub}{An integer specifying the number of observations per subject. Default: \code{5}.}

\item{seed}{An optional integer for setting the random seed to ensure reproducibility. Default: \code{NULL}.}

\item{nonlinear}{A logical value. If \code{TRUE}, the latent variable is generated using a complex
nonlinear function of the covariates. If \code{FALSE}, it is a linear combination. Default: \code{FALSE}.}

\item{residual}{A character string specifying the link function (CDF) used to generate probabilities from the latent variable.
This effectively acts as the error distribution assumption in a Generalized Linear Mixed Model (GLMM) context:
\itemize{
\item \code{"normal"}: Uses the standard normal CDF (Probit link).
\item \code{"logistic"}: Uses the logistic CDF (Logit link).
\item \code{"t3"}: Uses the Student's t (df=3) CDF.
\item \code{"t2"}: Uses the Student's t (df=2) CDF.
}}

\item{randeff}{A character string specifying the distribution of the random effects added to the latent variable.
Options are:
\itemize{
\item \code{"MVN"}: Multivariate Normal distribution.
\item \code{"MVN_mixture"}: Mixture of Multivariate Normal distributions.
\item \code{"skewed_MVN"}: Multivariate Skew-normal distribution.
\item \code{"MVT3"}: Multivariate t-distribution with 3 degrees of freedom.
\item \code{"MVT2"}: Multivariate t-distribution with 2 degrees of freedom.
}}
}
\value{
A list containing the following components:
\describe{
\item{subject_id_train}{A vector of subject IDs for the training set.}
\item{Z_train}{A matrix of random predictors (time/intercept) for the training set.}
\item{X_train}{A matrix of covariates for the training set.}
\item{Y_train}{A vector of \strong{observed binary outcomes} (0 or 1) for the training set.}
\item{subject_id_test}{A vector of subject IDs for the testing set.}
\item{Z_test}{A matrix of random predictors for the testing set.}
\item{X_test}{A matrix of covariates for the testing set.}
\item{Y_test}{A vector of \strong{true probabilities} for the testing set. These represent the ground truth propensity scores (0 to 1) used for evaluation.}
\item{X_pop}{A matrix of covariates for the entire population.}
\item{y_pop}{A vector of true probabilities for the entire population.}
\item{I}{A logical vector indicating which observations belong to the training set.}
\item{X_src}{Duplicate of \code{X_train}, provided for convenience.}
\item{Y_src}{Vector of true probabilities for the training set (unlike \code{Y_train} which is binary).}
}
}
\description{
Generates synthetic longitudinal data with binary outcomes, designed for evaluating
classification and prediction models. The function creates a latent continuous variable based on
covariates and random effects, then converts it into binary outcomes using various link functions
(corresponding to the \code{residual} argument).
}
\details{
The function simulates a latent continuous variable \eqn{Y^*} based on fixed effects (linear or nonlinear \code{X})
and random effects (\code{Z * Bi}). This latent variable is scaled and then transformed into a probability \eqn{p}
using the CDF specified by \code{residual}.

For the training set, the observed outcome \code{Y_train} is sampled from a Bernoulli distribution
with probability \eqn{p}. For the testing set, the function returns the probability \eqn{p} itself (\code{Y_test}),
allowing for precise evaluation of the model's ability to estimate propensity scores or risk.
}
\examples{
# Simulate data with logistic link (Logit) and mixture of normal random effects
sim_bin <- simulation_prediction_binary(
  train_prop = 0.7,
  n_subject = 500,
  residual = "logistic",
  randeff = "MVN_mixture",
  seed = 123
)
}
