% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor_analysis_matchingCriterion.R
\name{checkMatchingCriterion}
\alias{checkMatchingCriterion}
\title{Check Matching Criterion}
\usage{
checkMatchingCriterion(
  flowGraphAdjMatrix,
  adjMatrix,
  h,
  latentNodes,
  observedNodes,
  maxCard = length(observedNodes)
)
}
\arguments{
\item{flowGraphAdjMatrix}{matrix representing the basis flow graph for
any latent node h}

\item{adjMatrix}{of the graph}

\item{h}{latent node for which a tuple satisfying the criterion is sought}

\item{latentNodes}{set of latent nodes}

\item{observedNodes}{set of observed nodes}

\item{maxCard}{maximum size of set W}
}
\value{
a list consisting of a Boolean, whether the graph is
        sign-identifiable and if yes, a list consisting of the sets
}
\description{
for a latent node h, find a single observed node v and two sets of observed
nodes W and U so that the tuple satisfies the matching criterion
}
\references{
Sturma, N., Kranzlmüller, M., Portakal, I., and Drton, M.  (2025) Matching
Criterion for Identifiability in Sparse Factor Analysis.
arXiv:2502.02986
}
