% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fov.R
\docType{class}
\name{FOV-class}
\alias{FOV-class}
\alias{FOV}
\title{The Field of View Object}
\description{
A modern container for storing coordinates of spatially-resolved single
cells. Capable of storing multiple cell segmentation boundary masks.
Supports coordinates for spatially-resolved molecule (FISH) data.
Compatible with \code{\link{SpatialImage}}
}
\section{Slots}{

\describe{
\item{\code{molecules}}{A named list of
\code{\link[SeuratObject:Molecules-class]{Molecules}} objects defining
spatially-resolved molecular coordinates}

\item{\code{boundaries}}{A named list of
\code{\link[SeuratObject:Segmentation-class]{Segmentation}} and
\code{\link[SeuratObject:Centroids-class]{Centroids}} objects defining
spatially-resolved boundaries}

\item{\code{coords_x_orientation}}{A character indicating which axis 
\code{x} coordinates are associated with in spatial plots. 
Currently only applies to Visium objects. Ensures consistency in 
plotting spatial data across versions, as objects prior to the 
addition of this slot had \code{x} coordinates mapped to the vertical axis.}

\item{\code{assay}}{A character naming the associated assay
of the spatial coordinates}

\item{\code{key}}{A one-length character vector with the object's key; keys must
be one or more alphanumeric characters followed by an underscore
\dQuote{\code{_}} (regex pattern
\dQuote{\code{\Sexpr[stage=build]{SeuratObject:::.KeyPattern()}}})}
}}

\seealso{
\code{\link{FOV-methods}}
}
\concept{fov}
