% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/preprocessing5.R
\name{FetchResiduals}
\alias{FetchResiduals}
\alias{FetchResiduals.Seurat}
\alias{FetchResiduals.SCTAssay}
\title{Get the Pearson residuals from an sctransform-normalized dataset.}
\usage{
FetchResiduals(object, ...)

\method{FetchResiduals}{Seurat}(
  object,
  features,
  assay = NULL,
  umi.assay = "RNA",
  layer = "counts",
  clip.range = NULL,
  reference.SCT.model = NULL,
  replace.value = FALSE,
  na.rm = TRUE,
  verbose = TRUE,
  ...
)

\method{FetchResiduals}{SCTAssay}(
  object,
  umi.object,
  features,
  layer = "counts",
  clip.range = NULL,
  reference.SCT.model = NULL,
  replace.value = FALSE,
  na.rm = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{An SCTAssay object.}

\item{...}{Arguments passed to other methods (not used)}

\item{features}{Name of features to fetch residuals for.}

\item{assay}{Name of the assay to fetch residuals for.}

\item{umi.assay}{Name of the assay of the seurat object containing counts
matrix to use when recalculating any missing residuals.}

\item{layer}{The name of the layer(s) in `umi.assay` to use when 
recalculating any missing residuals.}

\item{clip.range}{Numeric of length two specifying the min and max values the
Pearson residual will be clipped to.}

\item{reference.SCT.model}{If provided, the reference model will be used
to recalculate missing residuals instead of the}

\item{replace.value}{Recalculate residuals for all features, even if they are
already present. Useful if you want to change the clip.range.}

\item{na.rm}{For features where there is no feature model stored, return NA
for residual value in scale.data when na.rm = FALSE. When na.rm is TRUE, only
return residuals for features with a model stored for all cells.}

\item{verbose}{Whether to print messages and progress bars}

\item{umi.object}{TK.}
}
\value{
A matrix containing the requested pearson residuals.
}
\description{
This function calls sctransform::get_residuals.
}
\seealso{
\code{\link[sctransform]{get_residuals}}
}
\concept{preprocessing}
