% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catch_adjust.R
\name{catch_adjust}
\alias{catch_adjust}
\title{catch_adjust}
\usage{
catch_adjust(
  old_minLS = NULL,
  old_maxLS = NULL,
  old_Lc = NULL,
  new_minLS = NULL,
  new_maxLS = NULL,
  new_Lc = NULL,
  catch = NULL,
  M = NULL,
  growth_model = c("vb", "gompertz", "schnute"),
  Linf = NULL,
  K = NULL,
  l0 = 0,
  tmax = NULL,
  Gom_Linf = NULL,
  Gom_K = NULL,
  Gom_l0 = NULL,
  g1 = NULL,
  g2 = NULL,
  l2 = NULL,
  Lmin = NULL,
  plot = FALSE,
  length_units = NULL
)
}
\arguments{
\item{old_minLS, old_maxLS, old_Lc}{Numeric. Historical slot limits and length at first capture.}

\item{new_minLS, new_maxLS, new_Lc}{Numeric. New slot limits and length at first capture. If
\code{new_Lc} is \code{NULL}, \code{old_Lc} is used.}

\item{catch}{Optional numeric. Historical catch to be adjusted. If provided,
\code{adjusted_catch = catch * (prop_new/prop_old)} is also computed.}

\item{M}{Numeric or \code{NULL}. Natural mortality. If \code{NULL},
defaults to \code{M = 4.899 * tmax^-0.916}.}

\item{growth_model}{One of \code{"vb"}, \code{"gompertz"}, \code{"schnute"}.}

\item{Linf, K, l0}{von Bertalanffy parameters; \code{l0} is start length (default 0).}

\item{tmax}{Numeric. The maximum observed age used to bound the integrals via \code{l(tmax)} and
in the default mortality estimator \code{M = 4.899 * tmax^-0.916}.}

\item{Gom_Linf, Gom_K, Gom_l0}{Gompertz parameters; requires \verb{0 < Gom_l0 < Gom_Linf}.}

\item{g1, g2, l2}{Schnute parameters; \code{l2} is length at \code{tmax}; requires \code{g1>0}, \code{l2>0},
and this parameterization assumes \code{g2 != 0}.}

\item{Lmin}{Optional numeric. Lower bound for the curve grid. If \code{NULL} it uses the
model’s start length (\code{l0}, \code{Gom_l0}, or \code{0}).}

\item{plot}{Logical. If \code{TRUE}, return a \code{ggplot2} plot.
Default \code{FALSE} (returns numeric catch adjustment only).}

\item{length_units}{Optional character scalar. Units to show in the x-axis
label when \code{plot = TRUE} (e.g., "mm" or "cm"). If \code{NULL} (default),
the label is simply "Length".}
}
\value{
If \code{plot = FALSE} (default): a numeric scalar \code{adjust_factor = prop_new/prop_old}.
If \code{plot = TRUE}: a list with
\itemize{
\item \code{prop_old}, \code{prop_new} — targeted proportions under old/new slots,
\item \code{adjust_factor} — \code{prop_new/prop_old},
\item \code{adjusted_catch} — only if \code{catch} provided,
\item \code{plot} — the \code{ggplot2} object (or \code{NULL} if \pkg{ggplot2} is unavailable).
}
}
\description{
Calculates the targeted proportions under historical (old) and proposed (new)
harvest slot limits using the same survivorship-by-length framework as
\code{\link{prop_target}}. The ratio ("catch adjustment") is returned, and (optionally)
a historical catch value is scaled by the adjustment. The optional plot overlays old/new
in-slot proportions on the normalized survivorship curve with arrows
indicating the direction of change (old → new).
}
\examples{
# numeric only
catch_adjust(old_minLS = 130, old_maxLS = 280, old_Lc = 80,
             new_minLS = 100, new_maxLS = 240,
             growth_model = "vb", Linf = 405, K = 0.118, l0 = 0, tmax = 34)

\donttest{
# with plot (requires ggplot2)
catch_adjust(old_minLS = 130, old_maxLS = 280, old_Lc = 80,
             new_minLS = 100, new_maxLS = 240,
             growth_model = "vb", Linf = 405, K = 0.118, l0 = 0,
             tmax = 34, plot = TRUE, length_units = "mm")
# note that overlapping portions stray from color in legend due to alpha value
catch_adjust(old_minLS = 100, old_maxLS = 150, old_Lc = 80,
             new_minLS = 160, new_maxLS = 300,
             growth_model = "vb", Linf = 405, K = 0.118, l0 = 0,
             tmax = 34, plot = TRUE, length_units = "mm")
}

}
