% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_glm.R
\name{p_glm}
\alias{p_glm}
\alias{gen_glm}
\title{p-value from (generalized) linear regression model simulations with fixed predictors}
\usage{
p_glm(
  formula,
  X,
  betas,
  test,
  sigma = NULL,
  family = gaussian(),
  gen_fun = gen_glm,
  return_analysis = FALSE,
  ...
)

gen_glm(formula, X, betas, sigma = NULL, family = gaussian(), ...)
}
\arguments{
\item{formula}{formula passed to either \code{\link{lm}} or
\code{\link{glm}}}

\item{X}{a data.frame containing the covariates}

\item{betas}{vector of slope coefficients that match the
\code{model.matrix} version of \code{X}}

\item{test}{character vector specifying the test to pass to
\code{\link[car]{lht}}. Can also be a list of character vectors
to evaluate multiple tests}

\item{sigma}{residual standard deviation for linear model. Only
used when \code{family = 'gaussian'}}

\item{family}{family of distributions to use (see \code{\link{family}})}

\item{gen_fun}{function used to generate the required discrete data.
Object returned must be a \code{data.frame}. Default uses \code{\link{gen_glm}}.
User defined version of this function must include the argument \code{...}}

\item{return_analysis}{logical; return the analysis object for further
extraction and customization?}

\item{...}{additional arguments to be passed to \code{gen_fun}. Not used
unless a customized \code{gen_fun} is defined}
}
\value{
a single p-value
}
\description{
p-values associated with (generalized) linear regression model.
Requires a pre-specified design matrix (\code{X}).
}
\examples{

X <- data.frame(G = factor(rep(c('control', 'treatment'), each=50)),
                C = sample(50:100, 100, replace=TRUE))
head(X)

# ANCOVA setup
p_glm(y ~ G + C, test="Gtreatment = 0",
  X=X, betas=c(10, .3, 1), sigma=1)

# return analysis model
p_glm(y ~ G + C, test="Gtreatment = 0",
  X=X, betas=c(10, .3, 1), sigma=1, return_analysis=TRUE)


# ANCOVA setup with logistic regression
p_glm(y ~ G + C, test="Gtreatment = 0",
  X=X, betas=c(-2, .5, .01), family=binomial())

# ANCOVA setup with poisson regression
p_glm(y ~ G + C, test="Gtreatment = 0",
  X=X, betas=c(-2, .5, .01), family=poisson())

\donttest{

# test whether two slopes differ given different samples.
#   To do this setup data as an MLR where a binary variable S
#   is used to reflect the second sample, and the interaction
#   effect evaluates the magnitude of the slope difference
gen_twogroup <- function(n, dbeta, sdx1, sdx2, sigma, n2_n1 = 1, ...){
  X1 <- rnorm(n, sd=sdx1)
  X2 <- rnorm(n*n2_n1, sd=sdx2)
  X <- c(X1, X2)
  N <- length(X)
  S <- c(rep(0, n), rep(1, N-n))
  y <- dbeta * X*S + rnorm(N, sd=sigma)
  dat <- data.frame(y, X, S)
  dat
}

# prospective power using test that interaction effect is equal to 0
p_glm(formula=y~X*S, test="X:S = 0",
	  n=100, sdx1=1, sdx2=2, dbeta=0.2,
	  sigma=0.5, gen_fun=gen_twogroup) |> Spower(replications=1000)

}


}
\seealso{
\code{\link{p_lm.R2}}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
