% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/singleSNPalt.R
\name{singleSNPalt}
\alias{singleSNPalt}
\title{singleSNPalt.R}
\usage{
singleSNPalt(
  lt,
  rt,
  tpos_ind,
  obs_ind,
  xMat,
  gMat,
  coxph = TRUE,
  survreg = TRUE
)
}
\arguments{
\item{lt}{n*1 vector of left side of time interval.}

\item{rt}{n*1 vector of right side of time interval.}

\item{tpos_ind}{n*1 binary vector of whether the event was observed after follow-up started (takes value 1 if t>0, 0 otherwise).}

\item{obs_ind}{n*1 vector of whether the event was observed or right-censored (takes value 1 if observed or 0 if right-censored).}

\item{xMat}{non-SNP covariates matrix.}

\item{gMat}{n*q genotype matrix.}

\item{coxph}{Boolean, whether to fit Cox PH model.}

\item{survreg}{Boolean, whether to fit survreg() Wiibull model.}
}
\value{
A list with the elements:
\item{pvalCox}{q*1 vector of marginal SNP p-values with Cox model}
\item{pvalSurv}{q*1 vector of marginal SNP p-values with survreg Weibull model}
}
\description{
Take a matrix of SNPs and get the interval-censored regression p-value for each one separately using either
survreg() or coxph() with midpoint approximation.
}
\examples{
set.seed(2)
gMat <- matrix(data=rbinom(n=200, size=2, prob=0.3), nrow=100)
xMat <- matrix(data=rnorm(200), nrow=100)
bhFunInv <- function(x) {x}
obsTimes <- 1:5
etaVec <- rep(0, 100)
outcomeDat <- gen_IC_data(bhFunInv = bhFunInv, obsTimes = obsTimes, windowHalf = 0.1,
probMiss = 0.1, etaVec = etaVec)
lt <- outcomeDat$leftTimes
rt <- outcomeDat$rightTimes
tpos_ind <- as.numeric(lt > 0)
obs_ind <- as.numeric(rt != Inf)
dmats <- make_IC_dmat(xMat, lt, rt, obs_ind, tpos_ind)
nullFit <- ICSKAT_fit_null(init_beta = rep(0, 5), left_dmat = dmats$left_dmat,
right_dmat=dmats$right_dmat, obs_ind = obs_ind, tpos_ind = tpos_ind, lt = lt, rt = rt)
singleSNPalt(lt = lt, rt = rt,tpos_ind = tpos_ind, obs_ind = obs_ind, xMat = xMat, gMat = gMat)

}
