% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotMetabolitePCA.R
\name{PlotMetabolitePCA}
\alias{PlotMetabolitePCA}
\title{PlotMetabolitePCA.}
\usage{
PlotMetabolitePCA(
  pca_res = NULL,
  sam = NULL,
  g = NULL,
  medsd = FALSE,
  text.col = "ID",
  legend.x = "bottomleft",
  comm = NULL
)
}
\arguments{
\item{pca_res}{A pcaRes object from the pcaMethods package.}

\item{sam}{Sample table including columns 'cols', 'pchs' (for data point color and shape) and 'ID' (to label data points) 'Group' (to split cols for legend) 'MP' (to adjust point size).}

\item{g}{Can be a factor vector of length=nrow(sam) and will influence legend and 'medsd'.}

\item{medsd}{Calculate mean and sd for groups and overlay PCA plot with this information.}

\item{text.col}{Data points may be overlaid by textual information, e.g. sample ID and 'text.col' specifies the column name of 'sam' to use for this purpose.}

\item{legend.x}{Position of a legend or NULL to omit it.}

\item{comm}{Will print commentary text to the bottom right of the plot (can be a character vector).}
}
\value{
A vector fo similar length as input but with various name components removed.
}
\description{
\code{PlotMetabolitePCA} will show PC1 and PC2 of a pcaMethods
  object and generate a flexible plot.
}
\details{
See examples.
}
\examples{
# load raw data and sample description
raw <- MetabolomicsBasics::raw
sam <- MetabolomicsBasics::sam

# calculate pca Result using pcaMethods and plot
pca_res <- pcaMethods::pca(raw, method = "rnipals", scale = c("none", "pareto", "uv")[2])
PlotMetabolitePCA(pca_res = pca_res, sam = sam, g = sam$GT)
# plot without legend and Group means instead
PlotMetabolitePCA(
  pca_res = pca_res, sam = sam, g = sam$GT, legend.x = NULL, text.col = NULL,
  medsd = TRUE, comm = LETTERS[1:4]
)

# readjust symbols before plotting
sam$Group <- interaction(sam$Origin, sam$Class, sep = "_")
sam[, c("cols", "pchs")] <- AdjustSymbols(cols = sam$Group, pchs = sam$Group)
PlotMetabolitePCA(pca_res = pca_res, sam = sam, g = sam$Group)
}
