% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmeans.fraction.R
\name{kmeans.fraction}
\alias{kmeans.fraction}
\title{k-means fraction}
\usage{
kmeans.fraction(x)
}
\arguments{
\item{x}{A numeric vector.}
}
\value{
A number.
}
\description{
Given a vector of cluster assigments from \code{quantify.outliers()} run with \code{method = 'kmeans'}, compute the fraction of observations belonging to the smaller of the two clusters.
}
\details{
This function only considers clusters 1 and 2 even if \code{quantify.outliers()} was run with \code{exclude.zero = TRUE}.  In that case, zeros are effectively excluded from the counts used to define the k-means fraction.  See examples.
}
\examples{
x <- c(1, 1, 2, 2, 2, 2, 2, 2, 2, 2);
names(x) <- letters[1:length(x)];
kmeans.fraction(x);
}
