% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svdstuff.R
\name{SVDMaster}
\alias{SVDMaster}
\title{R6 class for SVD master object to control worker objects generated by \code{\link[=SVDWorker]{SVDWorker()}}}
\description{
\code{SVDMaster} objects instantiate and run a distributed SVD computation
}
\seealso{
\code{\link[=SVDWorker]{SVDWorker()}} which goes hand-in-hand with this object
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SVDMaster-new}{\code{SVDMaster$new()}}
\item \href{#method-SVDMaster-kosher}{\code{SVDMaster$kosher()}}
\item \href{#method-SVDMaster-updateV}{\code{SVDMaster$updateV()}}
\item \href{#method-SVDMaster-updateU}{\code{SVDMaster$updateU()}}
\item \href{#method-SVDMaster-fixFit}{\code{SVDMaster$fixFit()}}
\item \href{#method-SVDMaster-reset}{\code{SVDMaster$reset()}}
\item \href{#method-SVDMaster-addSite}{\code{SVDMaster$addSite()}}
\item \href{#method-SVDMaster-run}{\code{SVDMaster$run()}}
\item \href{#method-SVDMaster-summary}{\code{SVDMaster$summary()}}
\item \href{#method-SVDMaster-clone}{\code{SVDMaster$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SVDMaster-new"></a>}}
\if{latex}{\out{\hypertarget{method-SVDMaster-new}{}}}
\subsection{Method \code{new()}}{
\code{SVDMaster} objects instantiate and run a distributed SVD computation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SVDMaster$new(defn, debug = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{defn}}{a computation definition}

\item{\code{debug}}{a flag for debugging, default \code{FALSE}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
R6 \code{SVDMaster} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SVDMaster-kosher"></a>}}
\if{latex}{\out{\hypertarget{method-SVDMaster-kosher}{}}}
\subsection{Method \code{kosher()}}{
Check if inputs and state of object are sane. For future use
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SVDMaster$kosher()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{TRUE} or \code{FALSE}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SVDMaster-updateV"></a>}}
\if{latex}{\out{\hypertarget{method-SVDMaster-updateV}{}}}
\subsection{Method \code{updateV()}}{
Return an updated value for the \code{V} vector, normalized by \code{arg}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SVDMaster$updateV(arg)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{arg}}{the normalizing value}

\item{\code{...}}{other args ignored}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
updated \code{V}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SVDMaster-updateU"></a>}}
\if{latex}{\out{\hypertarget{method-SVDMaster-updateU}{}}}
\subsection{Method \code{updateU()}}{
Update \code{U} and return the updated norm of \code{U}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SVDMaster$updateU(arg)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{arg}}{the normalizing value}

\item{\code{...}}{other args ignored}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
updated norm of \code{U}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SVDMaster-fixFit"></a>}}
\if{latex}{\out{\hypertarget{method-SVDMaster-fixFit}{}}}
\subsection{Method \code{fixFit()}}{
Construct the residual matrix using given the \code{V} vector and \code{d} so far
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SVDMaster$fixFit(v, d)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{v}}{the value for \code{v}}

\item{\code{d}}{the value for \code{d}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
result
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SVDMaster-reset"></a>}}
\if{latex}{\out{\hypertarget{method-SVDMaster-reset}{}}}
\subsection{Method \code{reset()}}{
Reset the computation state by initializing work matrix and set up starting values for iterating
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SVDMaster$reset()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SVDMaster-addSite"></a>}}
\if{latex}{\out{\hypertarget{method-SVDMaster-addSite}{}}}
\subsection{Method \code{addSite()}}{
Add a url or worker object for a site for participating in the distributed computation. The worker object can be used to avoid complications in debugging remote calls during prototyping.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SVDMaster$addSite(name, url = NULL, worker = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{of the site}

\item{\code{url}}{web url of the site; exactly one of \code{url} or \code{worker} should be specified}

\item{\code{worker}}{worker object for the site; exactly one of \code{url} or \code{worker} should be specified}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SVDMaster-run"></a>}}
\if{latex}{\out{\hypertarget{method-SVDMaster-run}{}}}
\subsection{Method \code{run()}}{
Run the distributed Cox model fit and return the estimates
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SVDMaster$run(thr = 1e-08, max.iter = 100)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{thr}}{the threshold for convergence, default 1e-8}

\item{\code{max.iter}}{the maximum number of iterations, default 100}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a named list of \code{V}, \code{d}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SVDMaster-summary"></a>}}
\if{latex}{\out{\hypertarget{method-SVDMaster-summary}{}}}
\subsection{Method \code{summary()}}{
Return the summary result
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SVDMaster$summary()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a named list of \code{V}, \code{d}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SVDMaster-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SVDMaster-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SVDMaster$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
