% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echoice2.R
\name{vd_est_vdm}
\alias{vd_est_vdm}
\title{Estimate volumetric demand model}
\usage{
vd_est_vdm(
  vd,
  tidy = TRUE,
  R = 1e+05,
  keep = 10,
  cores = NULL,
  error_dist = "EV1",
  control = list(include_data = TRUE)
)
}
\arguments{
\item{vd}{A tibble, containing volumetric demand data (long format)}

\item{tidy}{A logical, whether to apply 'echoice2' tidier function (default: TRUE)}

\item{R}{A numeric, no of draws}

\item{keep}{A numeric, thinning factor}

\item{cores}{An integer, no of CPU cores to use (default: auto-detect)}

\item{error_dist}{A string defining the error term distribution, 'EV1' or 'Normal'}

\item{control}{A list containing additional settings}
}
\value{
An 'echoice2' draw object, in the form of a list
}
\description{
Estimate volumetric demand model
}
\examples{
data(icecream)
#run MCMC sampler (use way more than 10 draws for actual use)
icecream_est <- icecream \%>\% dplyr::filter(id<50) \%>\% vd_est_vdm(R=10, cores=2)
}
\seealso{
\code{\link[=vd_dem_vdm]{vd_dem_vdm()}} to generate demand predictions based on this model

\code{\link[=vd_est_vdm_screen]{vd_est_vdm_screen()}} to estimate a volumetric demand model with screening
}
