% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_va_exgry.R
\name{get_va_exgry}
\alias{get_va_exgry}
\title{Detailed origin and final absorption of value added in gross exports}
\usage{
get_va_exgry(
  wio_object,
  va_type = "TC",
  flow_type = "EXGRY",
  geo_orig = "WLD",
  geo_export,
  sec_export = "TOTAL",
  geo_fd = "WLD",
  as_numeric = TRUE
)
}
\arguments{
\item{wio_object}{An object of class \code{wio}.}

\item{va_type}{String for domestic content (\code{"DC"}), foreign content
(\code{"FC"}) or total content (\code{"TC"}) from the perspective of the exporter.
As origin of value added is specified, this is normally redundant, but
in the case of exporter \code{"WLD"}, the domestic and foreign content is
considered as the sum of domestic/foreign contents of all individual
countries. For groups (such as \code{"EU27"}) domestic/foreign means value
added from within/outside the group.}

\item{flow_type}{String specifying the type of flow in terms of absorption.
It can be total gross exports (\code{"EXGRY"}), exports of final products
(\code{"EXGRY_FIN"}) or exports of intermediates (\code{"EXGRY_INT"}).}

\item{geo_orig}{Character string with code of country or country group
of origin of value added.}

\item{geo_export}{Character string with code of exporting country or
country group.}

\item{sec_export}{Character string with code of exporting sector or
sector group. Combinations (with \code{"|"}) and exceptions (with \code{"x"})
are allowed.}

\item{geo_fd}{String character with code of country or country group
of final destination of exports}

\item{as_numeric}{Boolean. If \code{TRUE} (default), returns a numeric
value, vector or matrix instead of a data frame (default for
\code{\link[=get_data]{get_data()}}).}
}
\value{
A matrix, vector or data frame with data of exports
}
\description{
Get exports in terms of final absorption by origin of
value added and final destination. It combines a \code{\link[=make_exvadir]{make_exvadir()}}
command and a \code{\link[=get_data]{get_data()}} command to obtain a result equivalent to
that of the OECD's Gross Exports by Origin of Value Added and
Final destination (\code{FD_EXGR_VA}, \code{FD_EXGRFNL_VA} and \code{FD_EXGRINT_VA}),
but with much more flexible geographical and sector options.
}
\examples{
# What part of French value added exported as US final intermediate
# manufactures ends up absorbed by Spain?
wio <- make_wio("iciotest")
get_va_exgry(wio, flow_type = "EXGRY_INT", geo_orig = "FRA",
             geo_export = "USA", sec_export = "MANUF", geo_fd = "ESP")
}
