% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_rms_norm}
\alias{ggml_rms_norm}
\title{RMS Normalization (Graph)}
\usage{
ggml_rms_norm(ctx, a, eps = 1e-05)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{Input tensor}

\item{eps}{Epsilon value for numerical stability (default: 1e-5)}
}
\value{
Tensor representing the RMS normalization operation
}
\description{
Creates a graph node for RMS (Root Mean Square) normalization.
Normalizes by x / sqrt(mean(x^2) + eps). CRITICAL for LLaMA models.
}
\examples{
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 4)
ggml_set_f32(a, c(1, 2, 3, 4))
result <- ggml_rms_norm(ctx, a, eps = 1e-5)
graph <- ggml_build_forward_expand(ctx, result)
ggml_graph_compute(ctx, graph)
output <- ggml_get_f32(result)
# sqrt(mean(output^2)) should be ~1
ggml_free(ctx)
}
}
