% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/density_plot.R
\name{density_plot}
\alias{density_plot}
\title{Plot density of TRUE/FALSE distributions}
\usage{
density_plot(dataset, q = NULL)
}
\arguments{
\item{dataset}{A data frame containing the calibration dataset, typically the output of an authorship analysis function like \code{\link[=impostors]{impostors()}}.}

\item{q}{This optional argument should be one value or a vector of values that contain the score of the disputed text(s). These are then plotted as lines crossing the density distributions.}
}
\value{
A \code{ggplot2} plot with the density distributions for the scores for TRUE (typically, 'same-author') vs. FALSE (typically, 'different-author').
}
\description{
Plot density of TRUE/FALSE distributions
}
\examples{
res <- data.frame(score = c(0.5, 0.2, 0.8, 0.01, 0.6), target = c(TRUE, FALSE, TRUE, FALSE, TRUE))
q <- c(0.11, 0.7)
density_plot(res, q)

}
