% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmult_transformations_mult.R
\name{.adjustUpperBoundForFreeParameters}
\alias{.adjustUpperBoundForFreeParameters}
\title{Adjusts Upper Bound For Free Parameters}
\usage{
.adjustUpperBoundForFreeParameters(
  theta_mat,
  k,
  upper,
  nr_mult_equal,
  smaller_values,
  larger_values,
  hyp_direction
)
}
\arguments{
\item{theta_mat}{matrix with samples from truncated Dirichlet density}

\item{k}{current parameter index}

\item{upper}{current upper bound}

\item{nr_mult_equal}{vector of multiplicative elements of collapsed parameters}

\item{smaller_values}{index of parameters that are smaller than the current one}

\item{larger_values}{index of parameters that are larger than the current one}

\item{hyp_direction}{specifies whether the imposed inequality constrained imposes an increasing (i.e., 'smaller') or
decreasing (i.e., 'larger') trend}
}
\value{
adjusted upper bound
}
\description{
Corrects the upper bound for current parameter. This correction only applies for parameters that are free to vary within
the restriction. Then the length of the remaining stick must be based on the largest free parameter value.
}
