% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-numeric.R
\name{numericInput}
\alias{numericInput}
\title{Create a numeric input control}
\usage{
numericInput(
  inputId,
  label,
  value,
  min = NA,
  max = NA,
  step = NA,
  width = NULL,
  ...,
  updateOn = c("change", "blur")
)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{value}{Initial value.}

\item{min}{Minimum allowed value}

\item{max}{Maximum allowed value}

\item{step}{Interval to use when stepping between min and max}

\item{width}{The width of the input, e.g. \code{'400px'}, or \code{'100\%'};
see \code{\link[=validateCssUnit]{validateCssUnit()}}.}

\item{...}{Ignored, included to require named arguments and for future
feature expansion.}

\item{updateOn}{A character vector specifying when the input should be
updated. Options are \code{"change"} (default) and \code{"blur"}. Use \code{"change"} to
update the input immediately whenever the value changes. Use \code{"blur"}to
delay the input update until the input loses focus (the user moves away
from the input), or when Enter is pressed (or Cmd/Ctrl + Enter for
\code{\link[=textAreaInput]{textAreaInput()}}).}
}
\value{
A numeric input control that can be added to a UI definition.
}
\description{
Create an input control for entry of numeric values
}
\section{Server value}{

A numeric vector of length 1.
}

\examples{
## Only run examples in interactive R sessions
if (interactive()) {

ui <- fluidPage(
  numericInput("obs", "Observations:", 10, min = 1, max = 100),
  verbatimTextOutput("value")
)
server <- function(input, output) {
  output$value <- renderText({ input$obs })
}
shinyApp(ui, server)
}

}
\seealso{
\code{\link[=updateNumericInput]{updateNumericInput()}}

Other input elements: 
\code{\link{actionButton}()},
\code{\link{checkboxGroupInput}()},
\code{\link{checkboxInput}()},
\code{\link{dateInput}()},
\code{\link{dateRangeInput}()},
\code{\link{fileInput}()},
\code{\link{passwordInput}()},
\code{\link{radioButtons}()},
\code{\link{selectInput}()},
\code{\link{sliderInput}()},
\code{\link{submitButton}()},
\code{\link{textAreaInput}()},
\code{\link{textInput}()},
\code{\link{varSelectInput}()}
}
\concept{input elements}
