% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcgaretriever_v_1_10_3.R
\name{get_molecular_data}
\alias{get_molecular_data}
\title{Retrieve Molecular Data corresponding to a Genetic Profile of Interest.}
\usage{
get_molecular_data(
  case_list_id,
  gprofile_id,
  glist = c("TP53", "E2F1"),
  dryrun = FALSE
)
}
\arguments{
\item{case_list_id}{String corresponding to the Identifier of a list of cases.}

\item{gprofile_id}{String corresponding to the Identifier of a genetic Profile of interest.}

\item{glist}{Vector including one or more gene identifiers (ENTREZID or OFFICIAL_SYMBOL). ENTREZID
gene identifiers should be passed as numeric.}

\item{dryrun}{Logical. If TRUE, all other arguments (if any) are ignored and 
a representative example is returned as output. No Internet connection is 
required for executing the operation when `dryrun` is TRUE.}
}
\value{
data.frame including the molecular data of interest. Rows are genes, columns are samples.
}
\description{
Retrieve Data corresponding to a Genetic Profile of interest from a cancer study of interest.
This function is the workhorse of the TCGAretriever package and can be used to fetch data 
concerning several genes at once. For retrieving mutation data, please use the `get_mutation_data()` function. 
For large queries (more than 500 genes), please use the `fetch_all_tcgadata()` 
function.
}
\examples{
# Set `dryrun = FALSE` (default option) in production!
x <- get_molecular_data(case_list_id = 'blca_tcga_3way_complete',
                        gprofile_id = 'blca_tcga_rna_seq_v2_mrna',
                        glist = c("TP53", "E2F1"), dryrun = TRUE)
x[, 1:10]


}
\references{
\url{https://www.data-pulse.com/dev_site/TCGAretriever/}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
