#' Example Workflow for TopicTestlet
#' 
#' @examples
#' \dontrun{
#' # 1. Simulate Data
#' N <- 100
#' J <- 5
#' # Numeric scores
#' scores <- matrix(sample(0:2, N*J, replace=TRUE), N, J)
#' # Text essays (random words for demo)
#' vocab <- c("logic", "reasoning", "evidence", "concept", "structure")
#' essays <- matrix(replicate(N*J, paste(sample(vocab, 10, replace=TRUE), collapse=" ")), N, J)
#' 
#' # 2. Aggregate text (Function 1)
#' text_vector <- aggregate_responses(essays)
#' 
#' # 3. Check Perplexity to choose K (Function 2)
#' perp_res <- ttm_perplexity(text_vector, k_range = 2:4)
#' print(perp_res)
#' best_k <- perp_res$k[which.min(perp_res$perplexity)]
#' 
#' # 4. Run LDA (Function 3)
#' delta <- ttm_lda(text_vector, k = best_k)
#' 
#' # 5. Fit Topic Testlet Model (Function 4)
#' model_results <- ttm_est(scores, delta)
#' 
#' # Inspect Results
#' hist(model_results$theta, main = "Student Abilities")
#' plot(model_results$gamma, model_results$theta, xlab = "Testlet Effect", ylab = "Ability")
#' }