## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(TrustworthyMLR)

# Simulate 5 runs of predictions
set.seed(42)
base <- rnorm(100)
preds <- matrix(rep(base, 5) + rnorm(500, sd = 0.1), ncol = 5)

# Calculate Stability
stability_index(preds)

# Visualize Stability
plot_stability(preds, main = "Prediction Stability Across Runs")

## -----------------------------------------------------------------------------
# Define a simple linear model
predict_fn <- function(X) X %*% c(1, -2, 3)

# Data
X <- matrix(rnorm(300), ncol = 3)

# Robustness Score
robustness_score(predict_fn, X, noise_level = 0.05)

# Visualize Robustness Decay
plot_robustness(predict_fn, X, main = "Robustness Decay Curve")

