map_to_int <- seq.int(0L, 23L, by = 1L)
names(map_to_int) <- unlist(strsplit("0123456789ABEZHIKMNOPTYX", split = ""))

pa_char_to_int <- function(c_v) {
  map_to_int[c_v]
}

mult_2_1 <- function(iv) {
  iv * (seq_along(iv) %% 2L + 1L)
}

alphabetic <- "ABEZHIKMNOPTYX"

get_letter <- function(index) {
  substr(alphabetic, index, index)
}

pa_compute_checksum <- function(v) {
  char_v_l <- base::strsplit(v, split = "")
  int_v_l <- base::lapply(char_v_l, pa_char_to_int)
  mult_l <- base::lapply(int_v_l, mult_2_1)
  fix_big_l <- base::lapply(mult_l, function(v) ifelse(v > 23L, v - 23L, v))
  sum_digits_v <- base::vapply(fix_big_l, FUN = sum, FUN.VALUE = NA_integer_)
  modulo_14_v <- -sum_digits_v %% 14
  index_v <- 1 + modulo_14_v
  base::vapply(index_v, FUN = get_letter, FUN.VALUE = NA_character_)
}

pa_has_correct_checksum <- function(v) {
  pa_compute_checksum(paste0(substr(v, 4L, 12L), substr(v, 1L, 2L))) ==
    substr(v, 3L, 3L)
}

#' Check validity of PA
#'
#' Given a character vector, for each of its elements,
#' check the validity of the Greek Personal Number (PA).
#' The PA allows numeric digits 0-9 and the
#' uppercase Latin letters whose uppercase
#' glyphs are the same in the Greek and Latin alphabet
#' (ABEZHIKMNOPTYX).
#'
#' @param v a character vector for whose elements validity of PA
#'   is checked.
#'
#' @return A logical vector.
#'
#' @examples
#' pa_check("ABYBADAFM999")
#' pa_check("ABY123456789")
#' pa_check("ABY12345678")
#' pa_check("ABY1234567890")
#' pa_check("5XY123456783")
#' pa_check(c("ABY123456789", "PTT111111114"))
#'
#' @export
pa_check <- function(v) {
  !is.na(v) &
    base::nchar(v) == 12L &
    grepl("^[0-9ABEZHIKMNOPTYX]{2}[ABEZHIKMNOPTYX][0-9]{9}$", v) &
    afm_check(substr(v, 4, 12)) &
    pa_has_correct_checksum(v)
}
