% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agroexcel.R
\name{agroexcel}
\alias{agroexcel}
\title{Exporta tablas agrobox o agrosintesis a Excel}
\usage{
agroexcel(x, file = "resultados_agro.xlsx")
}
\arguments{
\item{x}{data.frame o lista de data.frames.}

\item{file}{nombre del archivo Excel de salida.}
}
\value{
Invisiblemente TRUE si el archivo se genera correctamente.
}
\description{
Escribe una tabla individual o una lista de tablas
en un archivo Excel (.xlsx). Cuando se trata de una
lista, cada elemento se exporta como una hoja distinta.
}
\examples{
\dontrun{
# Ejemplo 1: tabla simple desde agrobox
aa <- agrobox(
  data = antigua2,
  variable = "harvwt",
  factor = "trt",
  test = "Duncan"
)

write_agro_excel(aa$tabla, file = "tabla_simple.xlsx")

# Ejemplo 2: lista de tablas desde agrosintesis
res <- agrosintesis(
  data = df_multi,
  variables = c("tn_ha", "peso_fruto"),
  estructura = "Variedad~Localidad",
  factor = "Fertilizante",
  factor2 = "Dosis",
  bloque = "Bloque",
  test = "Tukey"
)

write_agro_excel(res, file = "resultados_clusters.xlsx")
}

}
