% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/academic.R
\name{anki_exam_readiness}
\alias{anki_exam_readiness}
\title{Track exam readiness}
\usage{
anki_exam_readiness(
  path = NULL,
  profile = NULL,
  target_date,
  deck_pattern = NULL,
  new_cards_per_day = 20,
  target_retention = 0.9
)
}
\arguments{
\item{path}{Path to collection.anki2 (auto-detected if NULL)}

\item{profile}{Profile name (first profile if NULL)}

\item{target_date}{Exam date (Date or character "YYYY-MM-DD")}

\item{deck_pattern}{Pattern to match deck names (e.g., "Step1", "USMLE")}

\item{new_cards_per_day}{Expected new cards per day (default 20)}

\item{target_retention}{Target retention rate (default 0.90)}
}
\value{
A list with exam readiness analysis
}
\description{
Projects whether you'll complete cards before an exam, at what retention level.
Useful for medical board exam preparation.
}
\examples{
\dontrun{
readiness <- anki_exam_readiness(target_date = "2024-06-15", deck_pattern = "Step1")
}
}
