% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.R
\name{writePHMM}
\alias{writePHMM}
\title{Export profile hidden Markov models as text.}
\usage{
writePHMM(x, file = "", append = FALSE, form = "HMMER3", vers = "f")
}
\arguments{
\item{x}{an object of class \code{"PHMM"}.}

\item{file}{the name of the file to write the model to.}

\item{append}{logical indicating whether the model text should be appended
below any existing text in the output file, or whether any existing text
should be overwritten. Defaults to FALSE.}

\item{form}{character string indicating the format in which to write the model.
Currently only HMMER3f is supported.}

\item{vers}{character string indicating the version of version of the format
in which to write the model. Currently only "f" is supported.}
}
\value{
NULL (invisibly)
}
\description{
\code{writePHMM} takes an object of class \code{"PHMM"} and writes it to a
  text file in HMMER3 format.
}
\details{
This function writes an object of class \code{"PHMM"} to a
  HMMER3/f text file. Note that unlike HMMER, the \pkg{aphid}
  package does not currently support position-specific background
  emission probabilities.
}
\examples{
  ## Derive a profile hidden Markov model from the small globin alignment
  data(globins)
  x <- derivePHMM(globins, residues = "AMINO", seqweights = NULL)
  x
  fl <- tempfile()
  writePHMM(x, file = fl)
  readPHMM(fl)
  ##
  ## Derive a PHMM for the woodmouse data and write to file
  \donttest{
    library(ape)
    data(woodmouse)
    woodmouse.PHMM <- derivePHMM(woodmouse)
    tmpf <- tempfile(fileext = ".hmm")
    writePHMM(woodmouse.PHMM, file = tmpf)
  }
}
\references{
Finn, RD, Clements J & Eddy SR (2011) HMMER web server: interactive sequence
  similarity searching. \emph{Nucleic Acids Research}. \strong{39} W29-W37.
  \url{http://hmmer.org/}.

  HMMER: biosequence analysis using profile hidden Markov models.
  \url{http://www.hmmer.org}.
}
\seealso{
\code{\link{readPHMM}} to parse a PHMM object from a HMMER3 text file.
}
\author{
Shaun Wilkinson
}
