% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design_basic.R
\name{anova_rbd_pooled}
\alias{anova_rbd_pooled}
\title{Pooled Analysis of RBD Experiments (Multi-Environment/Year)}
\usage{
anova_rbd_pooled(
  data,
  response,
  treatment,
  environment,
  block,
  posthoc = "lsd",
  alpha = 0.05,
  verbose = TRUE
)
}
\arguments{
\item{data}{Data frame containing combined data from all environments}

\item{response}{Name of the response variable}

\item{treatment}{Name of treatment factor}

\item{environment}{Name of environment/year/location factor}

\item{block}{Name of block factor (nested within environment)}

\item{posthoc}{Post-hoc test method}

\item{alpha}{Significance level}

\item{verbose}{Logical. If TRUE (default), prints formatted output to console.}
}
\value{
List containing pooled ANOVA, individual ANOVAs, and interaction analysis
}
\description{
Performs pooled ANOVA for RBD experiments conducted across multiple 
environments, years, or locations. Tests homogeneity of error variances
using Bartlett's test before pooling.
}
\examples{
# Data from 3 years
data <- data.frame(
  year = rep(c("Y1", "Y2", "Y3"), each = 20),
  rep = rep(rep(1:4, each = 5), 3),
  treatment = rep(c("T1", "T2", "T3", "T4", "T5"), 12),
  yield = rnorm(60, 1200, 150)
)
anova_rbd_pooled(data, response = "yield", treatment = "treatment",
                 environment = "year", block = "rep")

}
\author{
Lalit Kumar Rolaniya, ICAR-IIPR, Bikaner
}
