% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_type.R
\name{assert_character_vector}
\alias{assert_character_vector}
\title{Assert input is a character vector}
\usage{
assert_character_vector(
  x,
  msg = NULL,
  call = rlang::caller_env(),
  arg_name = NULL
)
}
\arguments{
\item{x}{An object}

\item{msg}{A character string containing the error message to display if \code{x} is not a character vector}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
invisible(TRUE) if \code{x} is a character vector, otherwise aborts with the error message specified by \code{msg}
}
\description{
Assert an object is a character vector. Length 1 character vectors (strings) are considered vectors.
}
\examples{
try({
assert_character_vector(c("a", "b", "c")) # Passes
assert_character_vector(c("a", 1, "b")) # Throws default error
assert_character_vector(matrix(c('A', 'B', 'C', 'D')))  # Throws error since type = matrix
assert_character_vector(c("a", 1, "b"), "Custom error message") # Throws custom error
assert_character_vector(glue::glue('A')) # Throws error
})


}
\concept{assert_type}
