% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{am_uint64}
\alias{am_uint64}
\title{Create an unsigned 64-bit integer value}
\usage{
am_uint64(value = 0)
}
\arguments{
\item{value}{Numeric value (default 0). Values beyond 2^53 may lose precision.}
}
\value{
An \code{am_uint64} object
}
\description{
Creates an \code{am_uint64} object for storing unsigned 64-bit integers in Automerge
documents. This preserves type fidelity when syncing with other language
bindings (JavaScript BigInt, Python int, etc.).
}
\examples{
doc <- am_create()
am_put(doc, AM_ROOT, "id", am_uint64(12345))
am_close(doc)

}
