% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cursors.R
\name{am_cursor_equal}
\alias{am_cursor_equal}
\title{Test equality of two cursors}
\usage{
am_cursor_equal(cursor1, cursor2)
}
\arguments{
\item{cursor1}{An \code{am_cursor} object}

\item{cursor2}{An \code{am_cursor} object}
}
\value{
A logical scalar: \code{TRUE} if the cursors are equal, \code{FALSE} otherwise
}
\description{
Compares two cursors to determine if they refer to the same position
in a document. This compares the internal cursor representation, not
just the current position.
}
\examples{
doc <- am_create()
am_put(doc, AM_ROOT, "text", am_text("Hello World"))
text_obj <- am_get(doc, AM_ROOT, "text")

cursor1 <- am_cursor(text_obj, 5)
cursor2 <- am_cursor(text_obj, 5)
cursor3 <- am_cursor(text_obj, 3)

am_cursor_equal(cursor1, cursor2)  # TRUE
am_cursor_equal(cursor1, cursor3)  # FALSE

am_close(doc)

}
