% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cursors.R
\name{am_cursor_from_string}
\alias{am_cursor_from_string}
\title{Restore a cursor from a string}
\usage{
am_cursor_from_string(str, obj)
}
\arguments{
\item{str}{A character string containing a serialized cursor}

\item{obj}{An Automerge text object to associate the cursor with}
}
\value{
An \code{am_cursor} object
}
\description{
Restores a cursor from a string previously created by
\code{\link[=am_cursor_to_string]{am_cursor_to_string()}}. The text object is required to associate the
cursor with a document.
}
\examples{
doc <- am_create()
am_put(doc, AM_ROOT, "text", am_text("Hello World"))
text_obj <- am_get(doc, AM_ROOT, "text")

cursor <- am_cursor(text_obj, 5)
str <- am_cursor_to_string(cursor)

restored <- am_cursor_from_string(str, text_obj)
restored
am_cursor_position(restored)  # 5

am_close(doc)

}
\seealso{
\code{\link[=am_cursor_to_string]{am_cursor_to_string()}}
}
