% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.clogit_bclogit.R
\name{coef.clogit_bclogit}
\alias{coef.clogit_bclogit}
\title{Extract coefficients from a clogit_bclogit model}
\usage{
\method{coef}{clogit_bclogit}(object, ...)
}
\arguments{
\item{object}{A \code{clogit_bclogit} object.}

\item{...}{Additional arguments.}
}
\value{
Numeric vector of coefficients.
}
\description{
Extract coefficients from a clogit_bclogit model
}
\examples{
n <- 200
dat <- data.frame(
  y = rbinom(n, 1, 0.5), x1 = rnorm(n),
  treatment = rep(c(0, 1), n / 2),
  strata = rep(1:(n / 2), each = 2)
)
fit <- clogit(y ~ x1, data = dat, treatment = treatment, strata = strata)
coef(fit)
}
