% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaDelta-methods-diff-beta-delta.R
\name{print.diffbetadelta}
\alias{print.diffbetadelta}
\title{Print Method for an Object of Class \code{diffbetadelta}}
\usage{
\method{print}{diffbetadelta}(x, alpha = NULL, digits = 4, ...)
}
\arguments{
\item{x}{Object of class \code{diffbetadelta}.}

\item{alpha}{Numeric vector.
Significance level \eqn{\alpha}.
If \code{alpha = NULL},
use the argument \code{alpha} used in \code{x}.}

\item{digits}{Digits to print.}

\item{...}{additional arguments.}
}
\value{
Prints a matrix of
standardized regression slopes,
standard errors,
test statistics,
degrees of freedom,
p-values,
and
confidence intervals.
}
\description{
Print Method for an Object of Class \code{diffbetadelta}
}
\examples{
object <- lm(QUALITY ~ NARTIC + PCTGRT + PCTSUPP, data = nas1982)
std <- BetaDelta(object)
diff <- DiffBetaDelta(std)
print(diff)

}
\author{
Ivan Jacob Agaloos Pesigan
}
\keyword{methods}
