% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaDelta-methods-beta-delta.R
\name{summary.betadelta}
\alias{summary.betadelta}
\title{Summary Method for an Object of Class \code{betadelta}}
\usage{
\method{summary}{betadelta}(object, alpha = NULL, digits = 4, ...)
}
\arguments{
\item{object}{Object of class \code{betadelta}.}

\item{alpha}{Numeric vector.
Significance level \eqn{\alpha}.
If \code{alpha = NULL},
use the argument \code{alpha} used in \code{object}.}

\item{digits}{Digits to print.}

\item{...}{additional arguments.}
}
\value{
Returns a matrix of
standardized regression slopes,
standard errors,
test statistics,
degrees of freedom,
p-values,
and
confidence intervals.
}
\description{
Summary Method for an Object of Class \code{betadelta}
}
\examples{
object <- lm(QUALITY ~ NARTIC + PCTGRT + PCTSUPP, data = nas1982)
std <- BetaDelta(object)
summary(std)

}
\author{
Ivan Jacob Agaloos Pesigan
}
\keyword{methods}
