% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_calibration.R
\name{powertwoarmbinbf01}
\alias{powertwoarmbinbf01}
\title{Bayesian power, type-I error, and PCE(H0) for two-arm binomial Bayes factors}
\usage{
powertwoarmbinbf01(
  n1,
  n2,
  k = 1/3,
  k_f = 1/3,
  test = c("BF01", "BF+0", "BF-0", "BF+-"),
  a_0_d = 1,
  b_0_d = 1,
  a_0_a = 1,
  b_0_a = 1,
  a_1_d = 1,
  b_1_d = 1,
  a_2_d = 1,
  b_2_d = 1,
  a_1_a = 1,
  b_1_a = 1,
  a_2_a = 1,
  b_2_a = 1,
  output = c("numeric", "predDensmatrix", "t1ematrix", "ceH0matrix", "frequentist_t1e"),
  a_1_d_Hminus = 1,
  b_1_d_Hminus = 1,
  a_2_d_Hminus = 1,
  b_2_d_Hminus = 1,
  compute_freq_t1e = FALSE,
  p1_grid = seq(0.01, 0.99, 0.02),
  p2_grid = seq(0.01, 0.99, 0.02),
  p1_power = NULL,
  p2_power = NULL
)
}
\arguments{
\item{n1, n2}{Sample sizes in arms 1 and 2.}

\item{k}{Evidence threshold for rejecting the null (inverted BF).}

\item{k_f}{Evidence threshold for "compelling evidence" in favour of the null.}

\item{test}{Character string, one of \code{"BF01"}, \code{"BF+0"},
\code{"BF-0"}, \code{"BF+-"}.}

\item{a_0_d, b_0_d, a_0_a, b_0_a}{Shape parameters for design and analysis priors
under \eqn{H_0}.}

\item{a_1_d, b_1_d, a_2_d, b_2_d}{Shape parameters for design priors under
\eqn{H_1} or \eqn{H_+}.}

\item{a_1_a, b_1_a, a_2_a, b_2_a}{Shape parameters for analysis priors under
\eqn{H_1} or \eqn{H_+}.}

\item{output}{One of \code{"numeric"}, \code{"predDensmatrix"},
\code{"t1ematrix"}, \code{"ceH0matrix"}, \code{"frequentist_t1e"}.}

\item{a_1_d_Hminus, b_1_d_Hminus, a_2_d_Hminus, b_2_d_Hminus}{Optional design
priors under \eqn{H_-} for directional tests.}

\item{compute_freq_t1e}{Logical; if \code{TRUE}, compute frequentist
type-I error over a grid.}

\item{p1_grid, p2_grid}{Grids of true proportions for frequentist T1E.}

\item{p1_power, p2_power}{Optional true proportions for frequentist power.}
}
\value{
Depending on \code{output}, either a named numeric vector with
components \code{Power}, \code{Type1_Error}, \code{CE_H0} (and optionally
frequentist metrics) or matrices of predictive densities.
}
\description{
Computes Bayesian power, Bayesian type-I error, and the probability of
compelling evidence under H_0 (or H_- for BF+-), for a given
sample size and Bayes factor test. Optionally, frequentist type-I error
and frequentist power are computed by summing over the rejection region.
}
\examples{
# Basic Bayesian power for BF01 test
powertwoarmbinbf01(n1 = 30, n2 = 30, k = 1/3, test = "BF01")

# Directional test BF+0 with frequentist type-I error
powertwoarmbinbf01(n1 = 40, n2 = 40, k = 1/3, k_f = 3, 
                   test = "BF+0", compute_freq_t1e = TRUE)

# Predictive density matrices (advanced)
powertwoarmbinbf01(n1 = 25, n2 = 25, output = "predDensmatrix")
}
