% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arquiwos_une.R
\name{arquiwos_une}
\alias{arquiwos_une}
\title{Function that consolidates files in BibTeX format from the WoS database.}
\usage{
arquiwos_une(arquivos)
}
\arguments{
\item{arquivos}{is the database that contains the metadata in Bibtex format for the articles in the WoS collection.}
}
\value{
This function returns a dataframe containing the metadata for the articles in the WoS collection.
}
\description{
The function combines the various Bibtex files from the WoS collection into a single file. The function returns a list with the sequence of grouped files and a dataframe with the final Bibtex database.
}
\examples{

#Call the arquiwos_une function

file_db <- system.file("extdata","savedrecs.bib", package = "bibliorefer")
cabec_wos = TRUE
quoaspa_wos = ""
arquivos <- entrada_wos(file_db, cabec_wos, quoaspa_wos)

#Call the arquiwos_une function
base_arquiwos <- arquiwos_une(arquivos)
base_arquiwos



}
\references{
Aria, M. & Cuccurullo, C. (2017) bibliometrix: An R-tool for comprehensive science mapping analysis, Journal of Informetrics, 11(4), pp 959-975, Elsevier
}
