% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_bibliowos.R
\name{convert_bibliowos}
\alias{convert_bibliowos}
\title{Function that converts the BibTeX format from the WoS database to a CSV spreadsheet.}
\usage{
convert_bibliowos(arquivos)
}
\arguments{
\item{arquivos}{is the database that contains the metadata in Bibtex format for the articles in the WoS collection.}
}
\value{
This function returns a dataframe containing the metadata for the articles in the WoS collection.
}
\description{
The function converts the WoS database metadata file from Bibtex format to a CSV spreadsheet. The function's input is a file with the .bib extension. The function returns a dataframe.
}
\examples{

#Call the convert_bibliowos function

file_db <- system.file("extdata","savedrecs.bib", package = "bibliorefer")
cabec_wos = TRUE
quoaspa_wos = ""
arquivos <- entrada_wos(file_db, cabec_wos, quoaspa_wos)

#Call the convert_bibliowos function
font_wos <- convert_bibliowos(arquivos)
font_wos



}
\references{
Aria, M. & Cuccurullo, C. (2017) bibliometrix: An R-tool for comprehensive science mapping analysis, Journal of Informetrics, 11(4), pp 959-975, Elsevier
}
