% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/junt_scopuswos.R
\name{junt_scopuswos}
\alias{junt_scopuswos}
\title{This function converts the BibTeX format from the Scopus and WoS databases to a CSV spreadsheet.}
\usage{
junt_scopuswos(font_scopus, font_wos)
}
\arguments{
\item{font_scopus}{is the database that contains the metadata in Bibtex format for articles in the Scopus collection.}

\item{font_wos}{is the database that contains the metadata in Bibtex format for articles in the WoS collection.}
}
\value{
This function returns a dataframe containing the metadata for the articles in the Scopus and WoS collections.
}
\description{
This function converts metadata files from the Scopus and WoS databases in BibTeX format to a CSV spreadsheet. The function takes .bib files from the Scopus and WoS collections as input and returns a dataframe.
}
\examples{

#Call the junt_scopuswos function

file_db <- system.file("extdata","scopus.bib", package = "bibliorefer")
cabec = TRUE
quoaspa = ""
base_scopus <- entrada_scopus(file_db, cabec, quoaspa)
base_scopus <- as.data.frame(base_scopus)
variavel1 <- base_scopus$V1
variavel2 <- base_scopus$V2

#Call the convert_biblioscopus function
font_scopus <- convert_biblioscopus(variavel1,variavel2)

#Call the convert_bibliowos function

file_db <- system.file("extdata","savedrecs.bib", package = "bibliorefer")
cabec_wos = TRUE
quoaspa_wos = ""
arquivos <- entrada_wos(file_db, cabec_wos, quoaspa_wos)

#Call the convert_bibliowos function
font_wos <- convert_bibliowos(arquivos)

#Call the junt_scopuswos function
font_scopuswos <- junt_scopuswos(font_scopus,font_wos)
font_scopuswos



}
\references{
Aria, M. & Cuccurullo, C. (2017) bibliometrix: An R-tool for comprehensive science mapping analysis, Journal of Informetrics, 11(4), pp 959-975, Elsevier
}
