% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parser-block.R, R/parser-csv.R
\name{new_parser_block}
\alias{new_parser_block}
\alias{new_csv_block}
\title{Parser block constructors}
\usage{
new_parser_block(
  server,
  ui,
  class,
  ctor = sys.parent(),
  dat_valid = is_file,
  ...
)

new_csv_block(sep = ",", quote = "\\"", ...)
}
\arguments{
\item{server}{A function returning \code{\link[shiny:moduleServer]{shiny::moduleServer()}}}

\item{ui}{A function with a single argument (\code{ns}) returning a \code{shiny.tag}}

\item{class}{Block subclass}

\item{ctor}{String-valued constructor name or function/frame number (mostly
for internal use or when defining constructors for virtual classes)}

\item{dat_valid}{(Optional) input data validator}

\item{...}{Forwarded to \code{new_parser_block()} and \code{\link[=new_block]{new_block()}}}

\item{sep, quote}{Forwarded to \code{\link[utils:read.table]{utils::read.table()}}}
}
\value{
All blocks constructed via \code{new_parser_block()} inherit from
\code{parser_block}.
}
\description{
Operating on results from blocks created via \code{\link[=new_file_block]{new_file_block()}}, parser
blocks read (i.e. "parse") a file and make the contents available to
subsequent blocks for further analysis and visualization.
}
\details{
If using the default validator for a parser block sub-class (i.e. not
overriding the \code{dat_valid} argument in the call to \code{new_parser_block()}),
the data argument corresponding to the input file name must be \code{file} in
order to match naming conventions in the validator function.
}
\section{CSV block}{

Files in CSV format provided for example by a block created via
\code{\link[=new_file_block]{new_file_block()}} may be parsed into \code{data.frame} by CSV blocks.
}

