% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jobs.R
\name{db_jobs_repair_run}
\alias{db_jobs_repair_run}
\title{Repair A Job Run}
\usage{
db_jobs_repair_run(
  run_id,
  rerun_tasks = NULL,
  job_parameters = list(),
  latest_repair_id = NULL,
  performance_target = NULL,
  pipeline_full_refresh = NULL,
  rerun_all_failed_tasks = NULL,
  rerun_dependent_tasks = NULL,
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{run_id}{Job run ID of the run to repair. The run must not be in progress.}

\item{rerun_tasks}{Character vector. Task keys of the task runs to repair.}

\item{job_parameters}{Named list of job level parameters used in the run.}

\item{latest_repair_id}{The ID of the latest repair. This parameter is not required
when repairing a run for the first time, but must be provided on subsequent requests
to repair the same run.}

\item{performance_target}{The performance mode on a serverless job (either
\code{'PERFORMANCE_OPTIMIZED'} or \code{'STANDARD'}). The performance target determines
the level of compute performance or cost-efficiency for the run. This field
overrides the performance target defined on the job level.}

\item{pipeline_full_refresh}{Boolean. Controls whether the pipeline should perform
a full refresh.}

\item{rerun_all_failed_tasks}{Boolean. If \code{TRUE}, repair all failed tasks.
Only one of \code{rerun_tasks} or \code{rerun_all_failed_tasks} can be used.}

\item{rerun_dependent_tasks}{Boolean. If \code{TRUE}, repair all tasks that depend
on the tasks in \code{rerun_tasks}, even if they were previously successful. Can be
also used in combination with \code{rerun_all_failed_tasks.}}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\description{
Repair A Job Run
}
\details{
Parameters which are shared with \code{\link[=db_jobs_create]{db_jobs_create()}} are optional, only
specify those that are changing.
}
\seealso{
Other Jobs API: 
\code{\link{db_jobs_create}()},
\code{\link{db_jobs_delete}()},
\code{\link{db_jobs_get}()},
\code{\link{db_jobs_list}()},
\code{\link{db_jobs_reset}()},
\code{\link{db_jobs_run_now}()},
\code{\link{db_jobs_runs_cancel}()},
\code{\link{db_jobs_runs_delete}()},
\code{\link{db_jobs_runs_export}()},
\code{\link{db_jobs_runs_get}()},
\code{\link{db_jobs_runs_get_output}()},
\code{\link{db_jobs_runs_list}()},
\code{\link{db_jobs_runs_submit}()},
\code{\link{db_jobs_update}()}
}
\concept{Jobs API}
