% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_berufssprachkurssuche.R
\name{berufssprachkurssuche_search}
\alias{berufssprachkurssuche_search}
\title{Search language course offers}
\usage{
berufssprachkurssuche_search(
  params = list(),
  safe = TRUE,
  refresh = FALSE,
  flatten = FALSE,
  flatten_mode = "json"
)
}
\arguments{
\item{params}{Query parameters.}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}

\item{flatten}{Logical; drop nested list columns.}

\item{flatten_mode}{Flatten strategy for list columns. Use "unnest" to
expand list-columns into multiple rows.}
}
\value{
A tibble with course offers.

Includes \code{beginn_time}, \code{ende_time}, and \code{anmeldeschluss_time} as POSIXct in Europe/Berlin.
}
\description{
Search language course offers
}
\details{
The Berufssprachkurssuche API provides language course data. Authentication
can be done via OAuth2 client credentials or by sending the public client id
as \code{X-API-Key} (clientId \verb{bd24f42e-ad0b-4005-b834-23bb6800dc6c}). Official
docs: https://berufssprachkurssuche.api.bund.dev/.

\strong{Recommended:} Configure OAuth2 via \code{\link[=bunddev_auth_set]{bunddev_auth_set()}} with type \code{"oauth2"}.
If you provide a client secret, it fetches an OAuth token; otherwise it falls
back to sending the client ID as \code{X-API-Key}.
}
\examples{
\dontrun{
# Recommended: OAuth2 configuration
Sys.setenv(
  BERUFSSPRACHKURSSUCHE_API_KEY = "bd24f42e-ad0b-4005-b834-23bb6800dc6c",
  BERUFSSPRACHKURSSUCHE_CLIENT_SECRET = "<client-secret>"
)
bunddev_auth_set("berufssprachkurssuche",
  type = "oauth2",
  oauth_url = "https://rest.arbeitsagentur.de/oauth/gettoken_cc",
  env_var = "BERUFSSPRACHKURSSUCHE_API_KEY",
  oauth_secret_env = "BERUFSSPRACHKURSSUCHE_CLIENT_SECRET",
  oauth_default_id = "bd24f42e-ad0b-4005-b834-23bb6800dc6c")
berufssprachkurssuche_search(params = list(page = 0, systematiken = "MC"))
}

}
\seealso{
\code{\link[=bunddev_auth_set]{bunddev_auth_set()}} to configure authentication.
}
