% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_regionalatlas.R
\name{regionalatlas_query}
\alias{regionalatlas_query}
\title{Query Regionalatlas data}
\usage{
regionalatlas_query(
  table,
  where = "1=1",
  out_fields = "*",
  return_geometry = FALSE,
  params = list(),
  safe = TRUE,
  refresh = FALSE
)
}
\arguments{
\item{table}{Table name containing indicators (e.g., "ai002_1_5" for
population density). See Details for common tables.}

\item{where}{Optional SQL WHERE clause for filtering.}

\item{out_fields}{Fields to return (default "*" for all).}

\item{return_geometry}{Logical; include geometry in response.}

\item{params}{Additional query parameters.}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}
}
\value{
A tibble with regional indicator data.
}
\description{
Query Regionalatlas data
}
\details{
The Regionalatlas API provides access to over 160 regional indicators from
the German statistical offices. Data is available at various administrative
levels (Bundeslaender, Regierungsbezirke, Kreise, Gemeinden).
Official docs: https://github.com/bundesAPI/regionalatlas-api.

Common tables and their indicators:
\itemize{
\item \code{ai002_1_5}: Population (ai0201=density, ai0202=change, ai0208=foreigners \%)
\item \code{ai002_4_5}: Age (ai0218=average age, ai0219=mother age at 1st child)
\item \code{ai008_1_5}: Employment (ai0801=unemployment rate)
\item \code{ai_s_01}: Disposable income per capita
\item \code{ai_s_04}: SGB-II quota
\item \code{ai017_1}: GDP per employee
\item \code{ai005}: Federal election results
}

Regional levels in data: typ 1=Bundeslaender, 2=Regierungsbezirke, 3=Kreise,
5=Gemeinden. Filter using WHERE clause, e.g., \code{where = "typ = 1"}.
}
\examples{
\dontrun{
# Population density indicators
regionalatlas_query("ai002_1_5")

# Filter for Bundeslaender only
regionalatlas_query("ai002_1_5", where = "typ = 1")

# Age data for Kreise
regionalatlas_query("ai002_4_5", where = "typ = 3")
}

}
\seealso{
\code{\link[=bunddev_parameters]{bunddev_parameters()}} for available query parameters.
}
