% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axe-generics.R, R/rsample-indicators.R
\name{axe-rsample-indicators}
\alias{axe-rsample-indicators}
\alias{axe_rsample_indicators}
\alias{axe_rsample_indicators.default}
\alias{axe_rsample_indicators.rsplit}
\alias{axe_rsample_indicators.three_way_split}
\alias{axe_rsample_indicators.rset}
\alias{axe_rsample_indicators.tune_results}
\alias{axe_rsample_indicators.workflow_set}
\title{Axe indicators within rsample objects.}
\usage{
axe_rsample_indicators(x, verbose = FALSE, ...)

\method{axe_rsample_indicators}{default}(x, verbose = FALSE, ...)

\method{axe_rsample_indicators}{rsplit}(x, verbose = FALSE, ...)

\method{axe_rsample_indicators}{three_way_split}(x, verbose = FALSE, ...)

\method{axe_rsample_indicators}{rset}(x, verbose = FALSE, ...)

\method{axe_rsample_indicators}{tune_results}(x, verbose = FALSE, ...)

\method{axe_rsample_indicators}{workflow_set}(x, verbose = FALSE, ...)
}
\arguments{
\item{x}{An object.}

\item{verbose}{Print information each time an axe method is executed.
Notes how much memory is released and what functions are
disabled. Default is \code{FALSE}.}

\item{...}{Any additional arguments related to axing.}
}
\value{
An updated object without the indicators in the \code{rsplit} objects.
}
\description{
Replace the splitting and resampling objects with a placeholder.
}
\details{
Resampling and splitting objects produced by \pkg{rsample} contain \code{rsplit}
objects. These contain the original data set as well as indicators that
specify which rows go into which data partitions. These size of these
integers might be large so we sometimes wish to remove them when saving
objects. This method saves a zero-row integer in their place.
}
\section{Methods}{

See the following help topics for more details about individual methods:

\code{butcher}
\itemize{
\item \code{\link[butcher]{axe-rsample-indicators}}: \code{default},
\code{rset}, \code{rsplit}, \code{three_way_split}, \code{tune_results},
\code{workflow_set}
}
}

\examples{
\dontshow{if (rlang::is_installed("rsample")) withAutoprint(\{ # examplesIf}

large_cars <- mtcars[rep(1:32, 50), ]
large_cars_split <- rsample::initial_split(large_cars)
butcher(large_cars_split, verbose = TRUE)
\dontshow{\}) # examplesIf}
}
